#include "StdAfx.h"
#include "MODDERunner.h"

MODDERunner::MODDERunner(HANDLE DlgWVND)
   :mDlgWVND(DlgWVND)
{
}

MODDERunner::~MODDERunner(void)
{
}
std::vector<CString> MODDERunner::Run()
{
   mResultVec.clear();

   try
   {
      //Get the instance of MODDEQ / MODDE  / MODDEambr. "12100aac-82d1-444d-8c85-1ffe5ec0e4b1"
      moddeLib::IApplicationPtr pApp("MODDEQ.Application");
      //moddeLib::IApplicationPtr pApp("12100aac-82d1-444d-8c85-1ffe5ec0e4b1");
      
      //CoCreateInstance

      try
      {
         // If your license has an OEM password, set that before calling any other functions
         //pApp->SetOEMString(L"TheOEMPassword");
         CString strFilter = L"MODDE Investigation (*.mip)|*.mip|All Files (*.*)|*.*||";

         CFileDialog oDlg2(true, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, strFilter);
         oDlg2.m_ofn.lpstrTitle = L"Open MODDE Investigation";
         //Select investigation.
         {
            moddeLib::IInvestigationPtr pInv;
            moddeLib::IFactorPtr pFactor;
            moddeLib::IResponsePtr pResponse;
            moddeLib::IAnalysisPtr pAnalysis;
            moddeLib::IModelPtr pModel;
            moddeLib::IDesignPtr pDesign;

            LONG lFactors;
            LONG lResponses;
            _bstr_t szError;

            if(!pApp)
               AfxMessageBox(L"Modde did not start, perhaps not installed");

            if(pApp->IsLicenseFileValid() !=S_OK)
               AfxMessageBox(L"No license!");
            
            if (IDOK == oDlg2.DoModal())
            {
               CString strPath = oDlg2.GetPathName();

               mstrTempResult.Format(L"Investigation: %s",strPath);
               mResultVec.push_back(mstrTempResult);

               // Open the investigation
               pInv = pApp->OpenInvestigation(strPath.AllocSysString());

               if (!pInv)
                  AfxMessageBox(L"Unable to open the investigation");
            }

            // The Number of factors
            if(pInv->GetNumberOfFactors(&lFactors) != S_OK)
            {
               //the call failed, ask why.
               szError = pInv->GetLatestError();
               AfxMessageBox(szError);
            }
            //The Number of responses
            if(pInv->GetNumberOfResponses(&lResponses) != S_OK)
            {
               //the call failed, ask why.
               szError = pInv->GetLatestError();
               AfxMessageBox(szError);
            }
            //Log the Factors
            mResultVec.push_back(L"\r\n/////////////////////////////////////////////\r\nFACTORS\r\n/////////////////////////////////////////////\r\n");
            for(int iFactor=1; iFactor<= lFactors; ++iFactor)
            {
               //Get the factor interface.
               if(pInv->GetFactor(iFactor, (IDispatch**)&pFactor) != S_OK)
               {
                  //the call failed, ask why.
                  szError = pInv->GetLatestError();
                  AfxMessageBox(szError);
               }
               else
                  LogFactorData(pFactor);
            }

            //log the responses.
            mResultVec.push_back(L"\r\n/////////////////////////////////////////////\r\nRESPONSES\r\n/////////////////////////////////////////////\r\n");
            for(int iResponse=1; iResponse<= lResponses; ++iResponse)
            {
               //Get the response interface.
               if(pInv->GetResponse(iResponse, (IDispatch**)&pResponse) != S_OK)
               {
                  //the call failed, ask why.
                  szError = pInv->GetLatestError();
                  AfxMessageBox(szError);
               }
               else
                  LogResponseData(pResponse);
            }

            //Log the design.
            mResultVec.push_back(L"\r\n\r\n/////////////////////////////////////////////\r\nDESIGN\r\n/////////////////////////////////////////////\r\n");

            //Get the design interface.
            pDesign = pInv->GetDesign();
            if (pDesign == NULL)
            {
               //the call failed, ask why.
               szError = pInv->GetLatestError();
               AfxMessageBox(szError);
            }
            else
               LogDesignData(pDesign);


            //Log the results
            mResultVec.push_back(L"\r\n\r\n/////////////////////////////////////////////\r\nRESULTS\r\n/////////////////////////////////////////////\r\n");

            //Get the model interface.
            if(pInv->GetModel(1,(IDispatch**)&pModel) != S_OK)
            {
               //the call failed, ask why.
               szError = pInv->GetLatestError();
               AfxMessageBox(szError);
            }
            else
            {
               if(pModel->Fit(moddeLib::FitMethodPLSOnError) != S_OK)
               {
                  //the call failed, ask why.
                  szError = pInv->GetLatestError();
                  AfxMessageBox(szError);
               }

               //Get the analysis interface.
               if(pInv->GetAnalysis(1,(IDispatch**)&pAnalysis) != S_OK)
               {
                  szError = pInv->GetLatestError();
                  mResultVec.push_back((wchar_t*)szError);
               }
               else
               {
                  mResultVec.push_back(L"\r\n\r\n/////////////////////////////////////////////\r\nAnalysis\r\n/////////////////////////////////////////////\r\n");
                  LogResults(pAnalysis,pInv,pModel);
               }
            }
            RunOptimizer(pInv);
            //Save the investigation
            pInv->Save();
         }
      }
      catch(_com_error &e)
      {
         AfxMessageBox(e.ErrorMessage());
         _bstr_t szError = pApp->GetLatestError();
         AfxMessageBox(szError);
      }
      catch(...)
      {
         AfxMessageBox(L"FAILED");
         throw;

      }
   }
   catch(_com_error &e)
   {
      // If we end up here, there might be a problem with the license file.
      AfxMessageBox(e.ErrorMessage());
   }

   return mResultVec;
}

bool MODDERunner::LogFactorData(moddeLib::IFactorPtr pFactor)
{
   try
   {
      _bstr_t szFactorName;
      _bstr_t szFactorAbbr;
      _bstr_t szFactorUnit;
      _bstr_t szError;

      //Get the name
      if(pFactor->GetName(&szFactorName.GetBSTR()) != S_OK)
      {
         //the call failed, ask why.
         szError = pFactor->GetLatestError();
         AfxMessageBox(szError);
      }

      mstrTempResult.Format( L"%s\t",(wchar_t*)szFactorName);
      mstrVecTempResult=mstrTempResult;
      
      //the abbreviation
      if(pFactor->GetAbbreviation(&szFactorAbbr.GetBSTR()) != S_OK)
      {
         //the call failed, ask why.
         szError = pFactor->GetLatestError();
         AfxMessageBox(szError);
      }

      mstrTempResult.Format( L"%s\t",(wchar_t*)szFactorAbbr);
      mstrVecTempResult+=mstrTempResult;
      //the unit
      if(pFactor->GetUnit(&szFactorUnit.GetBSTR()) != S_OK)
      {
         //the call failed, ask why.
         szError = pFactor->GetLatestError();
         AfxMessageBox(szError);
      }

      mstrTempResult.Format( L"%s\t",(wchar_t*)szFactorUnit);
      mstrVecTempResult+=mstrTempResult;

      moddeLib::FactorType eType;
      //the type
      if(pFactor->GetType((LONG*)&eType) != S_OK)
      {
         //the call failed, ask why.
         szError = pFactor->GetLatestError();
         AfxMessageBox(szError);
      }

      switch(eType) {
         case moddeLib::Quantitative:
            mstrVecTempResult+="Quantitative\t";
            break;
         case moddeLib::QuantitativeMultiLevel:
            mstrVecTempResult+="MultiLevel\t";
            break;
         case moddeLib::Qualitative:
            mstrVecTempResult+="Qualitative\t";
            break;
         case moddeLib::Formulation:
            mstrVecTempResult+="Formulation\t";
            break;
         case moddeLib::Filler:
            mstrVecTempResult+="Filler\t";
            break;
         default:
            mstrVecTempResult+="UnDefined\t";
      }
      //the use
      moddeLib::FactorUse eUse;
      if(pFactor->GetUse((LONG*)&eUse) != S_OK)
      {
         //the call failed, ask why.
         szError = pFactor->GetLatestError();
         AfxMessageBox(szError);
      }

      switch(eUse) {
         case moddeLib::Controlled:
            mstrVecTempResult+="Controlled\t";
            break;
         case moddeLib::UnControlled:
            mstrVecTempResult+="UnControlled\t";
            break;
         case moddeLib::Constant:
            mstrVecTempResult+="Constant\t";
            break;
         default:
            mstrVecTempResult+="UnDefined\t";
      }

      //get settings
      VARIANT oSettings;
      VariantInit(&oSettings);
      if(pFactor->GetSettings(&oSettings) != S_OK)
      {
         //the call failed, ask why.
         szError = pFactor->GetLatestError();
         AfxMessageBox(szError);
      }
      

      if(oSettings.vt != VT_NULL)
      {
         //we have settings
         if(oSettings.vt == VT_R4)
         {
            //only one setting, a constant factor
            float fVal = oSettings.fltVal;
            mstrTempResult.Format( L"%7.4g\t",fVal);
            mstrVecTempResult+=mstrTempResult;
         }
         else if(oSettings.vt == (VT_ARRAY | VT_BSTR))
         {
            //several settings, a qualitative or multilevel.
            long ix[1];
            long lNum = oSettings.parray->rgsabound[0].cElements;
            if (lNum > 0)
            {
               for (long iColIter = 0; iColIter < lNum; ++iColIter)
               {
                  ix[0] = iColIter;
                  _bstr_t szString;
                  SafeArrayGetElement(oSettings.parray, ix, &szString.GetBSTR());

                  if (szString.length() > 0)
                  {
                     mstrTempResult.Format( L"%s\t",(wchar_t*)szString);
                     mstrVecTempResult+=mstrTempResult;
                  }
               }
            }
         }
         VariantClear(&oSettings);
      }
      else
      {
         // Lower and higher limits should only be printed if other settings don't exist.
         float fFactorLL;
         //the low limit
         if(pFactor->GetLowerLimit(&fFactorLL) != S_OK)
         {
            //the call failed, ask why.
            szError = pFactor->GetLatestError();
            AfxMessageBox(szError);
         }

         mstrTempResult.Format( L"%7.4g\t",fFactorLL);
         mstrVecTempResult+=mstrTempResult;
         mstrVecTempResult+="to\t";

         float fFactorHL;
         //the high limit
         if(pFactor->GetHigherLimit(&fFactorHL) != S_OK)
         {
            //the call failed, ask why.
            szError = pFactor->GetLatestError();
            AfxMessageBox(szError);
         }

         mstrTempResult.Format( L"%7.4g",fFactorHL);
         mstrVecTempResult+=mstrTempResult;
      }

      mResultVec.push_back(mstrVecTempResult);

      return true;
   }
   catch(_com_error &e)
   {
      AfxMessageBox(e.ErrorMessage());
   }
   catch(...)
   {
      AfxMessageBox(L"FAILED");
      throw;
   }
   return false;
}

bool MODDERunner::LogResponseData(moddeLib::IResponsePtr pResponse)
{
   try
   {
      _bstr_t szError;
      _bstr_t szResponseName;
      _bstr_t szResponseAbbr;
      _bstr_t szResponseUnit;
      
      //get the response name
      if(pResponse->GetName(&szResponseName.GetBSTR()) != S_OK)
      {
         //the call failed, ask why.
         szError = pResponse->GetLatestError();
         AfxMessageBox(szError);
      }

      mstrTempResult.Format( L"%s\t",(wchar_t*)szResponseName);
      mstrVecTempResult=mstrTempResult;
      
      //the Abbreviation.
      if(pResponse->GetAbbreviation(&szResponseAbbr.GetBSTR()) != S_OK)
      {
         //the call failed, ask why.
         szError = pResponse->GetLatestError();
         AfxMessageBox(szError);
      }

      mstrTempResult.Format( L"%s\t",(wchar_t*)szResponseAbbr);
      mstrVecTempResult+=mstrTempResult;

      //the units
      if(pResponse->GetUnit(&szResponseUnit.GetBSTR()) != S_OK)
      {
         //the call failed, ask why.
         szError = pResponse->GetLatestError();
         AfxMessageBox(szError);
      }

      mstrTempResult.Format( L"%s\t",(wchar_t*)szResponseUnit);
      mstrVecTempResult+=mstrTempResult;

      moddeLib::ResponseType eType;

      //the type
      if(pResponse->GetType((LONG*)&eType) != S_OK)
      {
         //the call failed, ask why.
         szError = pResponse->GetLatestError();
         AfxMessageBox(szError);
      }

      switch(eType) 
      {
      case moddeLib::Regular:
         mstrVecTempResult+="Regular\t";
         break;
      case moddeLib::Derived:
         mstrVecTempResult+="Derived\t";
         break;
      case moddeLib::Linked:
         mstrVecTempResult+="Linked\t";
         break;
      default:
         mstrVecTempResult+="UnDefined\t";
      }
      mResultVec.push_back( L"");

      //if the type is derived, get the formula.
      if (eType == moddeLib::Derived)
      {
         _bstr_t szFormula;

         if(pResponse->GetDerivedFormula(&szFormula.GetBSTR()) != S_OK)
         {
            //the call failed, ask why.
            szError = pResponse->GetLatestError();
            AfxMessageBox(szError);
         }
         mstrTempResult.Format(L"Formula: %s\t",(wchar_t*)szFormula);
         mstrVecTempResult+=mstrTempResult;
      }

      mResultVec.push_back(mstrVecTempResult);
      return true;
   }
   catch(_com_error &e)
   {
      AfxMessageBox(e.ErrorMessage());
   }
   catch(...)
   {
      AfxMessageBox(L"FAILED");
      throw;
   }
   return false;
}



bool MODDERunner::LogDesignData(moddeLib::IDesignPtr pDesign)
{
   try
   {
      _bstr_t szError;
      long iRuns;
      long iCenterPoints;
      CString strResult;
      
      //the number of runs.
      if(pDesign->GetRuns((LONG*)&iRuns) != S_OK)
      {
         //the call failed, ask why.
         szError = pDesign->GetLatestError();
         AfxMessageBox(szError);
      }
      else
      {
         strResult.Format(L"Runs: %d", iRuns);
         mResultVec.push_back(strResult);
      }
      //the number of centerpoints
      if(pDesign->GetCenterPoints((LONG*)&iCenterPoints) != S_OK)
      {
         //the call failed, ask why.
         szError = pDesign->GetLatestError();
         AfxMessageBox(szError);
      }
      else
      {
         strResult.Format(L"Center points: %d", iCenterPoints);
         mResultVec.push_back(strResult);
      }

      return true;
   }
   catch(_com_error &e)
   {
      AfxMessageBox(e.ErrorMessage());
   }
   catch(...)
   {
      AfxMessageBox(L"FAILED");
      throw;
   }
   return false;
}

bool MODDERunner::LogResults(moddeLib::IAnalysisPtr pAnalysis, moddeLib::IInvestigationPtr pInv, moddeLib::IModelPtr pModel)
{
   try
   {
      _bstr_t szError;
      moddeLib::IInvestigationDataPtr pInvestigationData;
      int iNumberOfComponents = 1;
      
      //Log R2
      if(pAnalysis->GetR2(iNumberOfComponents, (IDispatch**)&pInvestigationData) != S_OK)
      {
         //the call failed, ask why.
         szError = pAnalysis->GetLatestError();
         AfxMessageBox(szError);
      }
      else
      {
         // Print the results.
         LogInvestigationData(pInvestigationData);
      }

      //Log R2 adjusted
      if(pAnalysis->GetR2Adj(iNumberOfComponents, (IDispatch**)&pInvestigationData) != S_OK)
      {
         //the call failed, ask why.
         szError = pAnalysis->GetLatestError();
         AfxMessageBox(szError);
      }
      else
      {
         // Print the results.
         LogInvestigationData(pInvestigationData);
      }
      
      if(pAnalysis->GetQ2(iNumberOfComponents, (IDispatch**)&pInvestigationData) != S_OK)
      {
         //the call failed, ask why.
         szError = pAnalysis->GetLatestError();
         AfxMessageBox(szError);
      }
      else
      {
         // Print the results.
         LogInvestigationData(pInvestigationData);
      }
      
      LONG lVal;
      if(pAnalysis->GetNumberOfExperiments(&lVal) != S_OK)
      {
         //the call failed, ask why.
         szError = pAnalysis->GetLatestError();
         AfxMessageBox(szError);
      }
      mResultVec.push_back( L"Number of Experiments");
      mstrTempResult.Format( L"%d", lVal);
      mResultVec.push_back(mstrTempResult);

      float fVal;
      if(pAnalysis->GetConditionNumber(&fVal) != S_OK)
      {
         //the call failed, ask why.
         szError = pAnalysis->GetLatestError();
         AfxMessageBox(szError);
      }
      mResultVec.push_back( L"Condition number");
      mstrTempResult.Format( L"%7.4g", fVal);
      mResultVec.push_back(mstrTempResult);

      
      moddeLib::IResponsePtr pResponse;
      bstr_t szResponseName;
      //Get the first response name, to get the coefficients
      if(pInv->GetResponse(1, (IDispatch**)&pResponse) != S_OK)
      {
         //the call failed, ask why.
         szError = pInv->GetLatestError();
         AfxMessageBox(szError);
      }

      if(pResponse->GetName(&szResponseName.GetBSTR()) != S_OK)
      {
         //the call failed, ask why.
         szError = pResponse->GetLatestError();
         AfxMessageBox(szError);
      }
      if(pAnalysis->GetCoefficients(szResponseName,1,2,(IDispatch**)&pInvestigationData) != S_OK)
      {
         //the call failed, ask why.
         szError = pAnalysis->GetLatestError();
         AfxMessageBox(szError);
      }
      else
         LogInvestigationData(pInvestigationData);

      //Log scores, but only if PLS is selected.
      LONG eFitMethod, bUsePseudoComponents;
      if(pModel->GetFitMethod(1, &eFitMethod, &bUsePseudoComponents) && eFitMethod==3 )
      {
         if(pAnalysis->GetT(1, (IDispatch**)&pInvestigationData) != S_OK)
         {
            //the call failed, ask why.
            szError = pAnalysis->GetLatestError();
            AfxMessageBox(szError);
         }
         else
            LogInvestigationData(pInvestigationData);
      }
      return true;
   }
   catch(_com_error &e)
   {
      AfxMessageBox(e.ErrorMessage());
   }
   catch(...)
   {
      AfxMessageBox(L"FAILED");
      throw;
   }
   return false;
}

bool MODDERunner::LogInvestigationData(moddeLib::IInvestigationDataPtr pInvestigationData)
{
   try
   {
      moddeLib::IStringVectorPtr pRowIDs;
      moddeLib::IStringVectorPtr pColumnIDs;
      moddeLib::IFloatMatrixPtr pFloatMatrix;

      // Print the column names.
      pColumnIDs = pInvestigationData->GetColumnIDs();

      long lColumns = pColumnIDs->GetSize();

      mstrVecTempResult="\t";

      for (long lIx = 1; lIx <= lColumns; ++lIx)
      {
         _bstr_t strName = pColumnIDs->GetString(lIx);
         //Log the column name
         mstrTempResult.Format( L"%s\t", (const char*)strName);
         mstrVecTempResult+=mstrTempResult;
      }
      mResultVec.push_back(mstrVecTempResult);

      // Get the row names.
      pRowIDs = pInvestigationData->GetRowIDs();

      //Get the data matrix.
      pFloatMatrix = pInvestigationData->GetDataMatrix();

      long lRows = pRowIDs->GetSize();
      for (long lRow = 1; lRow <= lRows; ++lRow)
      {
         _bstr_t strName = pRowIDs->GetString(lRow);
         //Log the row name
         mstrTempResult.Format( L"%s\t", (const char*)strName);
         mstrVecTempResult=mstrTempResult;
         for (long lColumn = 1; lColumn <= lColumns; ++lColumn)
         {
            //Log the cell value
            float fVal = pFloatMatrix->GetData(lRow, lColumn);
            mstrTempResult.Format( L"%7.4g\t", fVal);
            mstrVecTempResult+=mstrTempResult;
         }
         mResultVec.push_back( mstrVecTempResult);
      }
      mResultVec.push_back(L"");
      mResultVec.push_back(L"");
      return true;
   }
   catch(_com_error &e)
   {
      AfxMessageBox(e.ErrorMessage());
   }
   catch(...)
   {
      AfxMessageBox(L"FAILED");
      throw;
   }
   return false;
}


void MODDERunner::RunOptimizer(moddeLib::IInvestigationPtr pInv)
{
   moddeLib::IOptimizerPtr pOptimizer;
   _bstr_t szError;
   moddeLib::IResponsePtr pResponse;
   
   mResultVec.push_back(L"\r\n\r\n/////////////////////////////////////////////\r\nOptimizer\r\n/////////////////////////////////////////////\r\n");
   
   //The Optimizer interface
   if(pInv->GetOptimizer((IDispatch**)&pOptimizer) != S_OK)
   {
      szError = pInv->GetLatestError();
      AfxMessageBox(szError);
   }
   bstr_t szResponseName;
   //Get the first response name
   if(pInv->GetResponse(1, (IDispatch**)&pResponse) != S_OK)
   {
      //the call failed, ask why.
      szError = pInv->GetLatestError();
      AfxMessageBox(szError);
   }

   if(pResponse->GetName(&szResponseName.GetBSTR()) != S_OK)
   {
      //the call failed, ask why.
      szError = pResponse->GetLatestError();
      AfxMessageBox(szError);
   }

   BSTR strName = szResponseName.GetBSTR();
   LONG iRuns;
   
   //Change the first response
   mResultVec.push_back(L"set first response to minimize, target=-0.7, max=0.5, weight=0.5");
   if(pOptimizer->SetResponseType(strName, 1) != S_OK)
   {
      //the call failed, ask why.
      szError = pOptimizer->GetLatestError();
      AfxMessageBox(szError);
   }
   if(pOptimizer->SetTarget(strName, -0.7f) != S_OK)
   {
      //the call failed, ask why.
      szError = pOptimizer->GetLatestError();
      AfxMessageBox(szError);
   }
   if(pOptimizer->SetMax(strName, 0.5f) != S_OK)
   {
      //the call failed, ask why.
      szError = pOptimizer->GetLatestError();
      AfxMessageBox(szError);
   }
   if(pOptimizer->SetWeight(strName, 0.5f) != S_OK)
   {
      //the call failed, ask why.
      szError = pOptimizer->GetLatestError();
      AfxMessageBox(szError);
   }

   //Setup start run settings
   mResultVec.push_back(L"GenerateStartRuns");
   //generate default 
   if(pOptimizer->GenerateStartRuns() != S_OK)
   {
      //the call failed, ask why.
      szError = pOptimizer->GetLatestError();
      AfxMessageBox(szError);
   }
   //Run the Optimizer
   mResultVec.push_back(L"Run");
   if(pOptimizer->Run() != S_OK)
   {
      //the call failed, ask why.
      szError = pOptimizer->GetLatestError();
      AfxMessageBox(szError);
   }
   //the number of runs
   if(pOptimizer->GetNumberOfRuns(&iRuns) != S_OK)
   {
      //the call failed, ask why.
      szError = pOptimizer->GetLatestError();
      AfxMessageBox(szError);
   }
   
   mResultVec.push_back(L"");

   mResultVec.push_back(L"/////////////////// LogD //////////////////////");
   CString strLogD;
   float fValue;
   for(int iR=1;iR<=iRuns;iR++)
   {
      if(pOptimizer->GetLogD(iR, &fValue) != S_OK)
      {
         //the call failed, ask why.
         szError = pOptimizer->GetLatestError();
         AfxMessageBox(szError);
      }
      fValue==-99 ? strLogD=L"N/A    " : strLogD.Format(L"%7.5g",fValue);
      mResultVec.push_back(strLogD);
   }
}